//-------------CByte4--------------------------
//-------------CByte4--------------------------
//-------------CByte4--------------------------
//-------------CByte4--------------------------


CSUtils = {}

let CInt4 = function (int4Tag, a, b, c, d) {
    this._int4Tag = int4Tag;
    this._a = a;
    this._b = b;
    this._c = c;
    this._d = d;
    CInt4._idDic[int4Tag] = this;
    //this._init(a, b, c, d);
}
CInt4.prototype = {
    o_id: 0,
    o_intLength: 4,
    _rangeIsError: 0,
    _int4Tag: "0_00_000_000",
    _a: 0,
    _b: 0,
    _c: 0,
    _d: 0,
    get m_className() {
        return "CInt4";
    },
    get id() {
        return this._int4Tag;
    },
    get tag() {
        return this._int4Tag;
    },
    get a() {
        return this._a;
    },
    get b() {
        return this._b;
    },
    get c() {
        return this._c;
    },
    get d() {
        return this._d;
    },

    _init: function (a, b, c, d, isShowErrorLog) {
        let _rangeIsError = CInt4.S_RangeIsError(a, b, c, d, isShowErrorLog);
        this._intLength = _rangeIsError ? 4 : 1;
        if (_rangeIsError) {
            this.o_id = 0;
        } else {
            this.o_id = a * 8388608 + b * 262144 + c * 512 + d;
            CInt4._idDic[this.o_id] = this;
        }
    },
    toString: function () {
        return this._int4Tag;
    }
}
CInt4._idDic = {};

CInt4.GetI4 = function (a, b, c, d) {
    let int4Tag = CInt4._GetInt4Tag(a, b, c, d);
    let obj = CInt4._idDic[int4Tag];
    if (obj == null) {
        obj = new CInt4(int4Tag, a, b, c, d);
    }
    return obj;

}
CInt4.Get = function (name) {
    let strArr = name.split("_");
    if (strArr.length < 4) {
        return null;
    }
    let a = parseInt(strArr[0])
    let b = parseInt(strArr[1])
    let c = parseInt(strArr[2])
    let d = parseInt(strArr[3])
    return CInt4.GetI4(a, b, c, d);
}

CInt4._GetInt4Tag = function (a, b, c, d) {
    let int4Tag = a + ("_" + numberFormatLen(b, 2)) + ("_" + numberFormatLen(c, 3)) + ("_" + numberFormatLen(d, 3))
    return int4Tag;
}


CInt4.Get_1122 = function (id, isShowErrorLog = false) {
    if (CInt4._idDic(id) != null) {
        return CInt4._idDic[id];
    }
    let arr = CInt4.GetABCD(id);
    return CInt4.Get(arr[0], arr[1], arr[2], arr[3], isShowErrorLog);
}

CInt4.GetABCD = function (id) {
    let aa = id / 8388608;
    let bb = id % 8388608 / 262144;
    let cc = id % 262144 / 512;
    let dd = id % 512;
    return [aa, bb, cc, dd];
}

/// <summary>
/// 范围是否错误
/// </summary>
CInt4.S_RangeIsError = function (a, b, c, d, isShowErrorLog) {
    if (CInt4.S_RangeIsError(a, -256, 256)) {
        if (isShowErrorLog) {
            Log.LogErrorFormat("超级错误.___{0}.____.a.越界", a, b, c, d,);
        }
        return true;
    }
    if (CInt4.S_RangeIsError(b, 0, 32)) {
        if (isShowErrorLog) {
            Log.LogErrorFormat("超级错误.____{0}.____.b.越界", a, b, c, d,);
        }
        return true;
    }
    if (CInt4.S_RangeIsError(c, 0, 512)) {
        if (isShowErrorLog) {
            Log.LogErrorFormat("超级错误.____{0}.____.c.越界", a, b, c, d,);
        }
        return true;
    }
    if (CInt4.S_RangeIsError(d, 0, 512)) {
        if (isShowErrorLog) {
            Log.LogErrorFormat("超级错误.____{0}.____.d.越界", a, b, c, d,);
        }
        return true;
    }
    return false;
}
/// <summary>
/// 范围是否错误
/// </summary>
CInt4.S_RangeIsError = function (value, min, max) {
    if (value < min) {
        return true;
    } else if (value > max) {
        return true;
    }
    return false;
}