//







function isIE() {
    if (window.ActiveXObject || "ActiveXObject" in window) {
        return true;
    } else {
        return false;
    }
}

 


//----------------------使用demo----------------------------------------------
// var cont = document.getElementById("arrowLine").getContext('2d');
// var a1 = S_CreateArrow(cont);
// a1.SetPoint({x: 350, y: 300}, {x: 200, y: 200});

/**
 * 实现两点间画箭头的功能
 * @author mapleque@163.com
 * @version 1.0
 * @date 2013.05.23
 */
//;(function (window, document) {
function S_CreateArrow(context, sp, ep, st) {
    if (context == null) {
        return null;
    }
    sp = sp == null ? {x: 0, y: 0} : sp;
    ep = ep == null ? {x: 0, y: 0} : ep;
    var proc = {
        SetCanvas: function (context) {
            this.m_context = context;
        },
        /**
         * 设置箭头起止点
         * @param sp起点
         * @param ep终点
         * @param st强度
         */
        SetPoint: function (sp, ep, st) {
            this.sp = sp;//起点
            this.ep = ep;//终点
            this.st = st;//强度
            this.DrawArrow();
        },
        /**
         * 设置箭头外观
         * @param args
         */
        setPara: function (args) {
            this.size = args.arrow_size;//箭头大小
            this.sharp = args.arrow_sharp;//箭头锐钝
        },
        DrawArrow: function () {
            var _this = this;
            var sp = _this.sp;
            var ep = _this.ep;
            if (this.m_context == undefined) {
                return;
            }
            var context = _this.m_context;
            //画箭头主线
            context.beginPath();
            context.moveTo(sp.x, sp.y);
            context.lineTo(ep.x, ep.y);
            //画箭头头部
            var h = _calcH(_this, sp, ep, context);
            context.moveTo(ep.x, ep.y);
            context.lineTo(h.h1.x, h.h1.y);
            context.moveTo(ep.x, ep.y);
            context.lineTo(h.h2.x, h.h2.y);
            context.stroke();
        },
    };

    //计算头部坐标
    var _calcH = function (_this, sp, ep, context) {
        var theta = Math.atan((ep.x - sp.x) / (ep.y - sp.y));
        var cep = _scrollXOY(ep, -theta);
        var csp = _scrollXOY(sp, -theta);
        var ch1 = {x: 0, y: 0};
        var ch2 = {x: 0, y: 0};
        var l = cep.y - csp.y;
        ch1.x = cep.x + l * (_this.sharp || 0.025);
        ch1.y = cep.y - l * (_this.size || 0.05);
        ch2.x = cep.x - l * (_this.sharp || 0.025);
        ch2.y = cep.y - l * (_this.size || 0.05);
        var h1 = _scrollXOY(ch1, theta);
        var h2 = _scrollXOY(ch2, theta);
        return {
            h1: h1,
            h2: h2
        };
    };
    //旋转坐标
    var _scrollXOY = function (p, theta) {
        return {
            x: p.x * Math.cos(theta) + p.y * Math.sin(theta),
            y: p.y * Math.cos(theta) - p.x * Math.sin(theta)
        };
    };


    proc.SetCanvas(context);
    proc.SetPoint(sp, ep, st);
    return proc;
}

//})(window, document)



////------------------------------------------------------
////
////
////
////
////
////
////
////---------------------2d向量-------------------------------------

//----2d向量----
let Vector2 = function (x, y) {
    this.x = x;
    this.y = y;
}
//Vector2.prototype = {}
Vector2.prototype.toString = function () {
    return this.x + "," + this.y;
}
Vector2.Distance = function (vv1, vv2) {
    let a = vv1.x - vv2.x;
    let b = vv1.y - vv2.y;
    return Math.pow(a * a + b * b, 0.5);
}

//自身的角度
Vector2.Angle = function (startPosi, endPosi) {
    let aa = (endPosi.x - startPosi.x);
    let bb = (endPosi.y - startPosi.y);
    if (bb == 0) {
        return 0;
    }
    if (aa == 0) {
        if (bb > 0) {
            return 90;
        } else {
            return -90;
        }
    }
    let theta = Math.atan(bb / aa);
    let angle = theta * 180 / 3.1415926;
    if (aa > 0) {
        return angle;
    } else {
        return angle - 180;
    }
}


////------------------------------------------------------

////
////----------------------io操作--------------------------------------


//-------保存文件到本地---------
function S_SaveData(filePath, data) {
    let fso = new ActiveXObject("Scripting.FileSystemObject");
    let file = fso.CreateTextFile(filePath, true);
    file.Write(data);
    file.Close();
}

//----打开路径选择窗口------------------
function S_BrowseFolder() {//对话框描述
    try {
        var Message = "请选择文件夹";  //选择框提示信息
        var Shell = new ActiveXObject("Shell.Application");

        //strDir = Shell.BrowseForFolder([默认目录], [对话框标题], [对话框描述], [是否允许用户创建目录])
        var Folder = Shell.BrowseForFolder(0, Message, 0x0040, 0x11);//起始目录为：我的电脑
        //var Folder = Shell.BrowseForFolder(0,Message,0); //起始目录为：桌面
        if (Folder != null) {
            Folder = Folder.items();  // 返回 FolderItems 对象
            Folder = Folder.item();  // 返回 Folderitem 对象
            Folder = Folder.Path;   // 返回路径
            if (Folder.charAt(Folder.length - 1) != "\\") {
                Folder = Folder + "\\";
            }
            //document.all.savePath.value=Folder;
            return Folder;
        } else {
            return null;
        }
    } catch (e) {
        alert(e.message);
        return null;
    }
}









