function Parse(value, def) {
    try {
        return float.Parse(value.trim());
    } catch {
        return def;
    }
}


//--
//--

CSUtils.WeDataTools = function () {
}
CSUtils.WeDataTools.prototype = {}

CSUtils.WeDataTools.S_WriterByteHead = function (binaryWriter) {
    binaryWriter.setUint32(1111111);
    //binaryWriter.Write(binaryWriter.BaseStream.Position);//test001------
    return binaryWriter._position;
}
CSUtils.WeDataTools.S_WriterByteEnd = function (binaryWriter, startPosition) {
    let endPosi = binaryWriter._position;
    let length = endPosi - startPosition;
    let position = startPosition - 4;
    binaryWriter.dataView.setUint32(position, length);
}

//--
//--

//--

CSUtils.WeDataTools.S_WriteByteArrayArray = function (binaryWriter, array, subType) {
    binaryWriter.setUint8(subType);
    let startPosi = this.S_WriterByteHead(binaryWriter);
    if (array != null) {
        array.forEach(function (value, key) {
            //console.log(value,key);
            this.S_WriteByteArray(binaryWriter, value, subType);
        });
    }
    this.S_WriterByteEnd(binaryWriter, startPosi);
}

CSUtils.WeDataTools.S_WriteByteArray = function (binaryWriter, array, subType) {
    binaryWriter.setUint8(subType);
    let startPosi = this.S_WriterByteHead(binaryWriter);
    if (array != null) {
        array.forEach(function (value, key) {
            //console.log(value,key);
            this.S_WriteByteObj(binaryWriter, value, subType);
        });
    }
    binaryWriter.S_WriterByteEnd(startPosi);
}

CSUtils.WeDataTools.S_WriteByteObj = function (binaryWriter, obj, baseType) {
    switch (baseType) {
        case EBaseType.e001_bool:
            let e001_bool = obj;
            binaryWriter.setUint8(e001_bool);
            break;
        case EBaseType.e003_byte:
            let e002_byte = obj;
            binaryWriter.setUint8(e002_byte);
            break;
        case EBaseType.e004_short:
            let e003_short = obj;
            binaryWriter.setInt16(e003_short);
            break;
        case EBaseType.e005_ushort:
            let e004_ushort = obj;
            binaryWriter.setUint16(e004_ushort);
            break;
        case EBaseType.e006_int:
            let e005_int = obj;
            binaryWriter.setInt32(e005_int);
            break;
        case EBaseType.e007_uint:
            let e006_uint = obj;
            binaryWriter.setUint32(e006_uint);
            break;
        case EBaseType.e008_float:
            let e007_float = obj;
            binaryWriter.setFloat32(e007_float);
            break;
        case EBaseType.e009_double:
            let e008_double = obj;
            binaryWriter.setFloat64(e008_double);
            break;
        case EBaseType.e010_long:
            let e009_long = obj;
            binaryWriter.setFloat64(e009_long);
            break;
        case EBaseType.e011_ulong:
            let e010_ulong = obj;
            binaryWriter.setFloat64(e010_ulong);
            break;
        case EBaseType.e012_string:
            if (obj == null) {
                binaryWriter.setUint16(0);
                return;
            }
            let e012_string = obj;
            let bytes = CBytes.S_stringToByte(e012_string);
            binaryWriter.setUint16(bytes.byteLength);
            binaryWriter.writeBytes(bytes, binaryWriter._position);
            break;
        case EBaseType.e013_Byte4:
            if (obj == null) {
                binaryWriter.setUint32(0);
                return;
            }
            let e013_bytes4 = obj;
            binaryWriter.setUint32(e013_bytes4.o_id);
            break;
        case EBaseType.e014_Int4:
            if (obj == null) {
                binaryWriter.setUint8(0);
                return;
            }
            let e014_int4 = obj;
            binaryWriter.setUint8(e014_int4.o_intLength);
            if (e014_int4.o_intLength == 1) {
                binaryWriter.setUint32(e014_int4.o_id);
            } else {
                binaryWriter.setUint32(e014_int4.a);
                binaryWriter.setUint32(e014_int4.b);
                binaryWriter.setUint32(e014_int4.c);
                binaryWriter.setUint32(e014_int4.d);
            }
            break;
        case EBaseType.e017_Enum:
            e005_int = obj;
            binaryWriter.setInt16(e005_int);
            break;
        case EBaseType.e018_array:
        case EBaseType.e019_arrayArray:
        case EBaseType.e026_list:
        case EBaseType.e037_dic:
        case EBaseType.e020_obj:
            Log.LogException("---数组不能直接调用这个方法4");
        case EBaseType.e021_weData:
            if (obj == null) {
                binaryWriter.setUint32(0);
                return;
            }
            let data = obj;
            if (data == null) {
                binaryWriter.setUint32(0);
            } else {
                binaryWriter.Write(data._instanceId);
            }
            break;
    }
}


//-------------------------------------------------------
//--
CSUtils.WeDataTools.S_ReadByteArrayArray = function (binaryReader, subType, uintObjDic) {
    let subType0 = binaryReader.getUint8();
    if (subType0 != subType) {
        Log.LogErrorFormat("错误....列表子类型不同_____________{0}._____{1}", subType0, subType);
    }

    let list = {};
    let langth = binaryReader.getUint32();
    if (langth == 0) {
        return list;
    }
    let endPosition = binaryReader._position + langth;
    let i = 0;
    while (binaryReader._position < endPosition) {
        list[i] = this.S_ReadByteArray(binaryReader, subType, uintObjDic);
        i++;
    }
    return list;
}
CSUtils.WeDataTools.S_ReadByteArray = function (binaryReader, subType, uintObjDic) {
    return this.S_ReadByteList(binaryReader, subType, uintObjDic);
}

CSUtils.WeDataTools.S_ReadByteList = function (binaryReader, subType, uintObjDic) {
    let subType0 = binaryReader.getUint8();
    if (subType0 != subType) {
        Log.LogErrorFormat("错误....列表子类型不同_____________{0}._____{1}", subType0, subType);
    }

    let list = {};
    let langth = binaryReader.getUint32();
    if (langth == 0) {
        return list;
    }
    let endPosition = binaryReader._position + langth;
    let i = 0;
    while (binaryReader._position < endPosition) {
        list[i] = this.S_ReadByteObj(binaryReader, subType, uintObjDic);
        i++;
    }
    return list;
}
CSUtils.WeDataTools.S_ReadByteObj = function (binaryReader, baseType, uintObjDic) {
    switch (baseType) {
        case EBaseType.e001_bool:
            return binaryReader.getUint8();
        case EBaseType.e003_byte:
            return binaryReader.getUint8();
        case EBaseType.e004_short:
            return binaryReader.getInt16();
        case EBaseType.e005_ushort:
            return binaryReader.getUint16();
        case EBaseType.e006_int:
            return binaryReader.getInt32();
        case EBaseType.e007_uint:
            return binaryReader.getUint32();
        case EBaseType.e008_float:
            return binaryReader.getFloat32();
        case EBaseType.e009_double:
            return binaryReader.getFloat64();
        case EBaseType.e010_long:
            return binaryReader.getFloat64();
        case EBaseType.e011_ulong:
            return binaryReader.getFloat64();
        case EBaseType.e012_string:
            let langth0 = binaryReader.getUint16();
            let bytes = binaryReader.buffer.slice(this._position, this._position + langth0);
            return CBytes.S_byteToString(bytes);
        case EBaseType.e013_Byte4:
            let id = binaryReader.getUint32();
            let byte4 = CByte4.GetByte4(id);
            return byte4;
        case EBaseType.e014_Int4:
            let length = binaryReader.getUint8();
            if (length == 0) {
                return null;
            } else if (length == 1) {
                let id = binaryReader.getInt32();
                let int40 = CInt4.GetInt4(id);
                return int40;
            } else if (length == 4) {
                let aa = binaryReader.getInt32();
                let bb = binaryReader.getInt32();
                let cc = binaryReader.getInt32();
                let dd = binaryReader.getInt32();
                let int4 = CInt4.GetInt4(aa, bb, cc, dd);
                return int4;
            } else {
                Log.LogErrorFormat("We读取CInt4.出错...length != 4");
                return null;
            }
        case EBaseType.e017_Enum:
            return binaryReader.getInt16();
        case EBaseType.e018_array:
        case EBaseType.e026_list:
        case EBaseType.e037_dic:
        case EBaseType.e020_obj:
            Log.LogException("---数组不能直接调用这个方法10");
            return null;
        case EBaseType.e021_weData:
            let instanceId = binaryReader.getUint32();
            return uintObjDic[instanceId];
    }
    return null;
}

//----字符串序列化----

///----字符串序列化----

//----字符串序列化----

///-----字符串序列化----
CSUtils.WeDataTools.S_WriteStringObjArrayArray = function (obj, baseType, subType) {
    let ss = "";
    obj.forEach(function (value, key) {
        value.forEach(function (value2, key) {
            ss = ss + this.S_WriteStringObj(value2, subType) + ",";
        });
        ss = ss + "+";
    });
    return ss;
}

CSUtils.WeDataTools.S_WriteStringObjArray = function (obj, baseType, subType) {
    let ss = "";
    obj.forEach(function (value, key) {
        ss = ss + this.S_WriteStringObj(value, subType) + ",";
    });
    return ss;
}

CSUtils.WeDataTools.S_WriteStringObj = function (obj, baseType) {
    if (obj == null) {
        return "0";
    }
    switch (baseType) {
        case EBaseType.e001_bool:
            return obj == true ? "1" : "0";
        case EBaseType.e003_byte:
        case EBaseType.e004_short:
        case EBaseType.e005_ushort:
        case EBaseType.e006_int:
        case EBaseType.e007_uint:
        case EBaseType.e008_float:
        case EBaseType.e009_double:
        case EBaseType.e010_long:
        case EBaseType.e011_ulong:
        case EBaseType.e017_Enum:
            return "" + obj;
        case EBaseType.e012_string:
            return obj;
        case EBaseType.e013_Byte4:
        case EBaseType.e014_Int4:
            return obj.toString();
        case EBaseType.e018_array:
        case EBaseType.e026_list:
        case EBaseType.e019_arrayArray:
        case EBaseType.e037_dic:
        case EBaseType.e020_obj:
            Log.LogException("---数组不能直接调用这个方法10");
            return "";
        case EBaseType.e021_weData:
            if (obj == null) {
                return "";
            } else {
                return data._instanceId + "";
            }
            return "";
    }
}


CSUtils.WeDataTools.S_ReadStringArrayArray = function (ss, subType, uintObjDic) {
    let sss = ss.split("+", "@");
    let list = {}
    if (sss.length <= 0) {
        return list;
    }
    for (let i = 0; i < sss.length; i++) {
        list[i] = this.S_ReadStringArray(sss[i], subType, uintObjDic);
    }
    return list;
}
CSUtils.WeDataTools.S_ReadStringArray = function (ss, subType, uintObjDic) {
    return this.S_ReadStringList(ss, subType, uintObjDic);
}
CSUtils.WeDataTools.S_ReadStringList = function (ss, subType, uintObjDic) {
    let sss = ss.split(",", "，");
    let list = {};
    if (sss.length <= 0) {
        return list;
    }
    for (let i = 0; i < sss.length; i++) {
        list[i] = this.S_ReadStringObj(sss[i], subType, uintObjDic);
    }
    return list;
}
CSUtils.WeDataTools.S_ReadStringObj = function (ss, baseType, uintObjDic) {
    switch (baseType) {
        case EBaseType.e001_bool:
            return ss == "1" ? true : false;
        case EBaseType.e003_byte:
        case EBaseType.e004_short:
        case EBaseType.e005_ushort:
        case EBaseType.e006_int:
        case EBaseType.e007_uint:
        case EBaseType.e008_float:
        case EBaseType.e009_double:
        case EBaseType.e010_long:
        case EBaseType.e011_ulong:
            return Number(ss);
        case EBaseType.e012_string:
            return ss;
        case EBaseType.e013_Byte4:
            return CByte4.GetByte4(ss);
        case EBaseType.e014_Int4:
            return CInt4.GetInt4(ss);
        case EBaseType.e017_Enum:
            return Number(ss);
        case EBaseType.e018_array:
        case EBaseType.e026_list:
        case EBaseType.e037_dic:
        case EBaseType.e020_obj:
            Log.LogException("---数组不能直接调用这个方法10");
            return "";
        case EBaseType.e021_weData:
            let instanceId = Number(ss);
            return uintObjDic[instanceId];
    }
    return "";
}


