binaryWriter = function () {
    this.buffer = new ArrayBuffer(4);
    this.dataView = new DataView(this.buffer);
}

binaryWriter.prototype = {
    buffer: null,
    dataView: null,
    _position: 0,
    _checkFixLength: function () {
        if (this.dataView.byteLength < this._position + 40) {
            let newLangth = this.dataView.byteLength * 2;
            if (newLangth > 2048) {
                newLangth = 2048;
            } else if (newLangth < 10) {
                newLangth = 10;
            }
            let array8 = new Uint8Array(newLangth);
            array8.set(new Uint8Array(this.buffer), 0);
            this.buffer = array8.buffer;
            this.dataView = new DataView(this.buffer);
            console.log(this.dataView.byteLength)
        }
    },
    writeBytes: function (buffer, copyStartIndex) {
        let array8 = new Uint8Array(this.buffer);
        array8.set(new Uint8Array(buffer), copyStartIndex);
        this.buffer = array8.buffer;
    },
    GetBuffer: function () {
        return this.buffer.slice(0, this._position);
    },
    // setInt8：写入1个字节的8位整数。
    setInt8: function (value) {
        this._checkFixLength();
        this.dataView.setInt8(this._position, value);
        this._position += 1;
    },
    // setUint8：写入1个字节的8位无符号整数。
    setUint8: function (value) {
        this._checkFixLength();
        this.dataView.setUint8(this._position, value);
        this._position += 1;
    },
    // setInt16：写入2个字节的16位整数。
    setInt16: function (value) {
        this._checkFixLength();
        this.dataView.setInt16(this._position, value);
        this._position += 2;
    },
    // setUint16：写入2个字节的16位无符号整数。
    setUint16: function (value) {
        this._checkFixLength();
        this.dataView.setUint16(this._position, value);
        this._position += 2;
    },
    // setInt32：写入4个字节的32位整数。
    setInt32: function (value) {
        this._checkFixLength();
        this.dataView.setInt32(this._position, value);
        this._position += 4;
    },
    // setUint32：写入4个字节的32位无符号整数。
    setUint32: function (value) {
        this._checkFixLength();
        this.dataView.setUint32(this._position, value);
        this._position += 4;
    },
    // setFloat32：写入4个字节的32位浮点数。
    setFloat32: function (value) {
        this._checkFixLength();
        this.dataView.setFloat32(this._position, value);
        this._position += 4;
    },
    // setFloat64：写入8个字节的64位浮点数。
    setFloat64: function (value) {
        this._checkFixLength();
        this.dataView.setFloat64(this._position, value);
        this._position += 8;
    },


}