let JSTree_nodeData = function () {
}
JSTree_nodeData.prototype = {
    isViewNode: true,
    isShow: true,
    name: "root",
    nodeDepth: 0,
    index: 0,
    childDic: {},
    parent: null,
}

const JSTree_style_position = "absolute";//static,absolute,fixed,relative,inherit

let JSTree_parameter = function () {
    this.o_nodeData = null;
    this.m_parentDiv = null;
    this.logicObj = null;
    this.onClick = null;
    this.startPosX = 20;
    this.startPosY = 100;
    this.treeWidth = 300;
    this.treeHigh = 600;

    this.isShowTitle = true;//是否显示标题头

    this.sliderLen = 100;
    this.tree_depthDistance = 20;
    this.tree_treeStartOffectX = 20;
    this.tree_treeStartOffectY = 20;
}


let JSTree = function () {
}
JSTree.prototype = {
    parameter: new JSTree_parameter(),
    temp_parentNodeObj: null,
    temp_currShowNodeIndex: 0,
    //o_cardObjArr: null,
    temp_showNodeDataArr: [],
    temp_currShowRootNodeData: null,
    Init: function (nodeData, m_parentDiv, onClick) {
        this.parameter.o_nodeData = nodeData;
        this.parameter.m_parentDiv = m_parentDiv;
        this.parameter.onClick = onClick;
        this.Init0();
    },
    Init0: function (parameter) {
        if (parameter != null) {
            this.parameter = parameter;
        }
        this.Init_root(this.parameter.m_parentDiv);
        this.Init_slider(this.m_root);
        this.o_cardObjArr = [];
        let number = (this.parameter.treeHigh - this.parameter.tree_treeStartOffectY) / 15;
        for (let i = 0; i < number; i++) {
            let node = this.Init_createNode(this.m_root, this);
            this.o_cardObjArr[this.o_cardObjArr.length] = node;
        }
        this.refresh_ShowData(this.parameter.o_nodeData);
    },
    Init_root: function (m_parentDiv) {
        let m_root = document.createElement('a');
        this.m_root = m_root;
        m_root.style.position = JSTree_style_position;//绝对位置-非常重要的属性 
        m_root.style.left = this.parameter.startPosX + "px";
        m_root.style.top = this.parameter.startPosY + "px";
        m_root.style.width = this.parameter.treeWidth + "px";
        m_root.style.height = this.parameter.treeHigh + "px";
        m_root.style.zIndex = 0;
        m_root.style.backgroundColor = "#999999";
        m_root.nameStr = "m_root"
        m_parentDiv.appendChild(m_root);
        CardDrag_shieldDrag(m_root)

        if (this.parameter.isShowTitle) {
            let m_labelBar = document.createElement('a');
            this.m_labelBar = m_labelBar;
            m_labelBar.style.position = "fixed"//绝对位置-非常重要的属性 
            m_labelBar.style.left = this.parameter.startPosX + "px";
            m_labelBar.style.top = this.parameter.startPosY + "px";
            m_labelBar.style.width = this.parameter.treeWidth + "px";
            m_labelBar.style.height = this.parameter.tree_treeStartOffectY + "px";
            m_labelBar.style.zIndex = 0;
            m_labelBar.style.fontSize = "5px";
            m_labelBar.style.backgroundColor = "#334444";
            m_labelBar.innerText = "标题栏";
            m_labelBar.nameStr = "m_labelBar"
            m_root.appendChild(m_labelBar);
            CardDrag_SetDrag(m_labelBar);
            //m_labelBar.o_posXIsFixed = true;
            m_labelBar.o_thisObj = this;
            m_labelBar.d_dragEvent = function (thisObj, type, press_posX, press_posY) {
                if (type == 1) {
                    thisObj.temp_press_posX = thisObj.m_root.offsetLeft;
                    thisObj.temp_press_posY = thisObj.m_root.offsetTop;
                } else if (type == 2) {
                    thisObj.m_root.style.left = (thisObj.temp_press_posX + press_posX) + "px";
                    thisObj.m_root.style.top = (thisObj.temp_press_posY + press_posY) + "px";
                }
            };
            let m_closeBtn = document.createElement('a');
            this.m_closeBtn = m_closeBtn;
            m_closeBtn.style.position = JSTree_style_position //绝对位置-非常重要的属性 
            m_closeBtn.style.left = (this.parameter.treeWidth - this.parameter.tree_treeStartOffectX) + "px";
            m_closeBtn.style.top = "0px";
            m_closeBtn.style.width = this.parameter.tree_treeStartOffectX + "px";
            m_closeBtn.style.height = this.parameter.tree_treeStartOffectY + "px";
            m_closeBtn.style.zIndex = 0;
            m_closeBtn.style.fontSize = "5px";
            m_closeBtn.style.backgroundColor = "#998811";
            m_closeBtn.innerText = " X";
            m_closeBtn.nameStr = "m_closeBtn"
            let thisObj = this;
            m_closeBtn.onclick = function () {
                thisObj.S_destroy(thisObj);
            };
            m_root.appendChild(m_closeBtn);
        } else {
            this.parameter.tree_treeStartOffectY = 0;
        }
    },
    Init_slider: function (m_parentDiv) {
        let wide = 15;
        let m_sliderBg = document.createElement('a');
        this.m_sliderBg = m_sliderBg;
        m_sliderBg.style.position = JSTree_style_position;//绝对位置-非常重要的属性 
        m_sliderBg.style.left = "0px";
        m_sliderBg.style.top = (this.parameter.tree_treeStartOffectY) + "px";
        m_sliderBg.style.width = wide + "px";
        m_sliderBg.style.height = (this.parameter.treeHigh - this.parameter.tree_treeStartOffectY) + "px";
        m_sliderBg.style.zIndex = 0;
        m_sliderBg.style.backgroundColor = "#333333";
        m_sliderBg.nameStr = "m_sliderBg"
        m_parentDiv.appendChild(m_sliderBg);


        let m_slider = document.createElement('a');
        this.m_slider = m_slider;
        m_slider.style.position = JSTree_style_position;//绝对位置-非常重要的属性 
        m_slider.style.left = "0px";
        m_slider.style.top = (this.parameter.tree_treeStartOffectY) + "px";
        m_slider.style.width = wide + "px";
        m_slider.style.height = this.parameter.sliderLen + "px";
        m_slider.style.zIndex = 0;
        m_slider.style.backgroundColor = "#ff0099";
        m_slider.nameStr = "m_slider"
        m_parentDiv.appendChild(m_slider);
        m_slider.o_thisObj = this;
        m_slider.o_posXIsFixed = true;
        m_slider.o_posYmin = this.parameter.tree_treeStartOffectY;
        m_slider.o_posYMax = this.parameter.treeHigh - this.parameter.sliderLen;
        m_slider.d_dragEvent = this.S_sliderDrag;
        CardDrag_SetDrag(m_slider);
    },

    S_sliderDrag: function (treeObj, type, press_posX, press_posY) {
        if (type == 3 || type == 2) {
            let _ResetShowNodeObjArr = function (thisObj, _nodeData) {
                if (_nodeData.isShow) {
                    let len = thisObj.temp_showNodeDataArr.length;
                    thisObj.temp_showNodeDataArr[len] = _nodeData;
                    if (_nodeData.childDic != null) {
                        Object.keys(_nodeData.childDic).sort().forEach(function (key) {
                            _ResetShowNodeObjArr(thisObj, _nodeData.childDic[key]);
                        });
                    }
                }
            }
            let len = press_posY;// - thisObj.startPosY
            let range = treeObj.parameter.treeHigh - treeObj.parameter.sliderLen - treeObj.parameter.tree_treeStartOffectY;

            let ratio = len / range;
            treeObj.temp_showNodeDataArr = [];

            _ResetShowNodeObjArr(treeObj, treeObj.parameter.o_nodeData);

            let length = treeObj.temp_showNodeDataArr.length
            let numberf = ratio * length;
            let number = Math.round(numberf)

            number = Math.min(number, length - 1)
            number = Math.max(number, 0)

            let nodeData = treeObj.temp_showNodeDataArr[number];
            if (nodeData == null) {
                cc.error("超级错误...............nodeData==null........%d....%d", number, length)
            }

            treeObj.refresh_ShowData(nodeData);
        }
    },

    refresh_ShowData: function (nodeData) {
        let _refresh_ShowData = function (treeObj, nodeData) {
            if (treeObj.temp_currShowNodeIndex < treeObj.o_cardObjArr.length) {
                treeObj.temp_lastSubObj = null;
                let nodeObj = treeObj.o_cardObjArr[treeObj.temp_currShowNodeIndex]
                let childDic = nodeData.childDic;
                nodeData.childKeyArr = Object.keys(childDic).sort();
                nodeObj.S_RefreshDataShow(nodeData, nodeData.nodeDepth, treeObj.temp_currShowNodeIndex);
                treeObj.temp_currShowNodeIndex++;

                if (nodeData.isShow) {
                    nodeData.childKeyArr.forEach(function (key) {
                        let _nodeData = childDic[key]
                        if (_nodeData.isViewNode) {
                            treeObj.temp_lastSubObj = _refresh_ShowData(treeObj, _nodeData);
                        }
                    });
                }
                if (treeObj.temp_lastSubObj == null) {
                    if (nodeData.childKeyArr != null && nodeData.childKeyArr.length > 0) {
                        nodeObj.S_RefreshSubLineShow(true, nodeObj.posX + treeObj.parameter.tree_depthDistance, treeObj.parameter.treeHigh - treeObj.parameter.tree_treeStartOffectY);
                    } else {
                        nodeObj.S_RefreshSubLineShow(false, 0, 0);
                    }
                } else {
                    nodeObj.S_RefreshSubLineShow(true, treeObj.temp_lastSubObj.posX, treeObj.temp_lastSubObj.posY);
                }
                return nodeObj;
            } else {
            }
            return null;
        }
        let _ShowDataArr = function (treeObj, childDic, index) {//处理父级的下半边显示问题
            let childKeyArr = Object.keys(childDic).sort();
            //cc.log("_ShowParentDataArr........", index, nodeData.name)
            for (let i = index; i < childKeyArr.length; i++) {
                let key = childKeyArr[i];
                let childNodeData = childDic[key]
                if (childNodeData == null) {
                    cc.error("超级错误...............childNodeData==null")
                }
                _refresh_ShowData(treeObj, childNodeData);
            }
        }

        let _ShowParentDataArr = function (treeObj, nodeData) {//处理父级显示问题
            if (nodeData == null) {
                return;
            }
            //cc.log("_ShowParentDataArr...%s......%d.", nodeData.name, nodeData.index)
            if (nodeData.parent != null) {
                _ShowDataArr(treeObj, nodeData.parent.childDic, nodeData.index)
            }
            _ShowParentDataArr(treeObj, nodeData.parent);
        }
        //cc.trace("_ShowParentDataArr...%s......%s........%d.......%d", nodeData.name, nodeData.pathTag, nodeData.nodeDepth, nodeData.index)
        this.temp_currShowRootNodeData = nodeData;
        this.temp_currShowNodeIndex = 0;
        if (nodeData.isShow) {
            _refresh_ShowData(this, nodeData);
        }
        _ShowParentDataArr(this, nodeData)

        if (this.temp_currShowNodeIndex < this.o_cardObjArr.length) {
            for (let i = this.temp_currShowNodeIndex; i < this.o_cardObjArr.length; i++) {
                this.o_cardObjArr[i].S_SetIsShow(false)
            }
        }
    },

    Init_createNode: function (m_parentDiv, o_treeObj) {
        //console.log("创建a......." + keyName)
        let wide = 200;
        let high = 15;
        let style_position = "absolute";//static,absolute,fixed,relative,inherit
        let o_cardObj = {};
        o_cardObj.localName = "nodeObj";
        o_cardObj.o_treeObj = o_treeObj;
        o_cardObj.posX = 0;
        o_cardObj.posY = 0;
        o_cardObj.nodeCount = 0;


        let parentLine = document.createElement('a');
        o_cardObj.m_parentLine = parentLine;
        parentLine.o_cardObj = o_cardObj;
        parentLine.style.position = style_position;//绝对位置-非常重要的属性 
        parentLine.style.width = high + "px";
        parentLine.style.height = "1px";
        parentLine.style.zIndex = 0;
        parentLine.style.backgroundColor = "#776677";
        m_parentDiv.appendChild(parentLine);

        let subLine = document.createElement('a');
        o_cardObj.m_subLine = subLine;
        subLine.o_cardObj = o_cardObj;
        subLine.style.position = style_position;//绝对位置-非常重要的属性 
        subLine.style.width = "1px";
        subLine.style.height = "1px";
        subLine.style.zIndex = 0;
        subLine.style.backgroundColor = "#776677";
        m_parentDiv.appendChild(subLine);


        let img = document.createElement('a');
        o_cardObj.m_img = img;
        img.o_cardObj = o_cardObj;
        img.style.position = style_position;//绝对位置-非常重要的属性 
        img.style.width = high + "px";
        img.style.height = high + "px";
        img.style.zIndex = 0;
        img.style.backgroundColor = "#ffaa00";
        m_parentDiv.appendChild(img);

        let text = document.createElement('a');
        o_cardObj.m_text = text;
        text.o_cardObj = o_cardObj;
        //text.innerText = tree_parameter.temp_nodeData.name;
        text.style.position = style_position;//绝对位置-非常重要的属性 
        text.style.width = wide + "px";
        text.style.height = high + "px";
        text.style.zIndex = 0;
        text.style.fontSize = "5px";
        text.style.backgroundColor = "#aaff99";
        m_parentDiv.appendChild(text);

        o_cardObj.S_SetIsShow = function (isShow) {
            if (isShow) {
                this.m_parentLine.style.display = "block";
                this.m_subLine.style.display = "block";
                this.m_img.style.display = "block";
                this.m_text.style.display = "block";
            } else {
                this.m_parentLine.style.display = "none";
                this.m_subLine.style.display = "none";
                this.m_img.style.display = "none";
                this.m_text.style.display = "none";
            }
        }

        o_cardObj.S_RefreshDataShow = function (nodeData, depth, nodeCount) {
            this.posX = depth * this.o_treeObj.parameter.tree_depthDistance;
            this.posY = nodeCount * (high + 0.002);
            this.o_currNodeData = nodeData;
            let offecttX = 0;
            let startPosX = this.o_treeObj.parameter.tree_treeStartOffectX;
            let startPosY = this.o_treeObj.parameter.tree_treeStartOffectY;
            this.m_parentLine.style.left = (startPosX + this.posX + offecttX) + "px";
            this.m_parentLine.style.top = (startPosY + this.posY + high * 0.5) + "px";
            offecttX += this.m_parentLine.offsetWidth;

            this.m_img.style.left = (startPosX + this.posX + offecttX) + "px";
            this.m_img.style.top = (startPosY + this.posY) + "px";
            offecttX += this.m_img.offsetWidth + 5;

            this.m_text.style.left = (startPosX + this.posX + offecttX) + "px";
            this.m_text.style.top = (startPosY + this.posY) + "px";
            this.m_text.innerText = nodeData.name;
            //refreshParameter.temp_tagStr += "___."
            //cc.log(refreshParameter.temp_tagStr + this.keyName + "...." + this.posX + "...." + this.m_text.style.top + "....." + this.nodeCount);
            if (nodeData.childKeyArr == null || nodeData.childKeyArr.length == 0) {
                this.m_img.style.backgroundColor = "#cccccc";
            } else {
                if (nodeData.isShow) {
                    this.m_img.style.backgroundColor = "#ffaa00";
                } else {
                    this.m_img.style.backgroundColor = "#ff33ff";
                }
            }
            this.S_SetIsShow(true)
            return this;
        }
        o_cardObj.S_RefreshSubLineShow = function (isHasSubData, lastSubObj_posX, lastSubObj_posY) {
            if (isHasSubData == null || isHasSubData == false) {
                this.m_subLine.style.display = "none";
            } else {
                this.m_subLine.style.display = "block";
                this.m_subLine.style.width = "1px";
                this.m_subLine.style.height = (lastSubObj_posY - this.posY) + "px";
                this.m_subLine.style.left = (this.o_treeObj.parameter.tree_treeStartOffectX + lastSubObj_posX) + "px";
                this.m_subLine.style.top = (this.o_treeObj.parameter.tree_treeStartOffectY + this.posY + high * 0.5) + "px";
            }
        }
        let S_onClick = function () {
            let o_cardObj = this.o_cardObj;
            let nodeData = o_cardObj.o_currNodeData;
            nodeData.isShow = !nodeData.isShow;
            o_cardObj.o_treeObj.refresh_ShowData(o_cardObj.o_treeObj.temp_currShowRootNodeData);
        }
        o_cardObj.m_img.onclick = S_onClick;
        o_cardObj.m_text.onclick = function () {
            let parameter = this.o_cardObj.o_treeObj.parameter;
            if (parameter.onClick != null) {
                parameter.onClick(parameter.logicObj, this.o_cardObj.o_currNodeData);
            }
        }
        return o_cardObj;
    },


    S_destroy: function (thisObj) {
        cc.trace("ssssss")
        thisObj.parameter.m_parentDiv.removeChild(thisObj.m_root);
    },
}


JSTree.Tree_ShowWeType = function (m_rootDiv) {
    let nodeData = new JSTree_nodeData();
    nodeData.name = "WeData数据类型";
    nodeData.isViewNode = true;
    nodeData.isShow = true;
    nodeData.nodeDepth = -1;
    nodeData.index = 0;
    nodeData.childDic = {}
    nodeData.pathTag = "root";

    for (let onlyPathTag in WeDataDic) {
        //cc.log("加载..........", onlyPathTag)
        let weObj = WeDataDic[onlyPathTag];
        let arr = onlyPathTag.split('_');
        let parentNode = nodeData;
        let pathTag = "";
        for (let i in arr) {
            let strId = arr[i];
            pathTag += strId + "-";
            let subNodeData = parentNode.childDic[strId];
            if (subNodeData == null) {
                subNodeData = new JSTree_nodeData();
                subNodeData.name = strId;
                subNodeData.pathTag = pathTag;
                subNodeData.nodeDepth = parseInt(i);
                subNodeData.index = Object.keys(parentNode.childDic).length;
                subNodeData.isViewNode = true;
                subNodeData.isShow = true;
                subNodeData.childDic = {}
                subNodeData.parent = parentNode;
                parentNode.childDic[strId] = subNodeData;
            }
            parentNode = subNodeData;
        }
        parentNode.name = onlyPathTag + "_" + weObj.m_className;
        parentNode.data = weObj;
    }
    let jsTree = new JSTree();
    // jsTree.Init(nodeData, m_rootDiv, function (nodeData) {
    //     if (nodeData.data != null) {
    //         // let thisObj = uiRoot.o_ArtTreeView
    //         // let fullPath = thisObj.prjDir + "/" + nodeData.data.path
    //         // cc.log("加载对象........" + fullPath)
    //         // WebPost_FileRead(fullPath, "text", thisObj.S_OpenWeDataView)
    //     }
    // });

    let parameter = new JSTree_parameter();
    parameter.o_nodeData = nodeData;
    parameter.m_parentDiv = m_rootDiv;
    parameter.onClick = function (logicObj, nodeData) {
        if (nodeData.data != null) {
            // let thisObj = uiRoot.o_ArtTreeView
            // let fullPath = thisObj.prjDir + "/" + nodeData.data.path
            // cc.log("加载对象........" + fullPath)
            // WebPost_FileRead(fullPath, "text", thisObj.S_OpenWeDataView)
        }
    };
    //parameter.isShowTitle = false;//是否显示标题头 

    jsTree.Init0(parameter);
}