//type XMLHttpRequestResponseType = "" | "arraybuffer" | "blob" | "document" | "json" | "text";

function _init_webData() {
    if (document.c_data != null && document.c_data.isInit != null) {
        return;
    }
    document.c_data = {}
    document.c_data.isInit = true;
    if (document.c_data.url == null) {
        document.c_data.url = rootUrl;//'http://127.0.0.1:8822';
    }
}

//responseType--returnType
//"" _________________ 空的 responseType 字符串与默认类型 "text" 相同。
//"arraybuffer" ______ 是一个包含二进制数据的 JavaScript ArrayBuffer。
//"blob" _____________ 是一个包含二进制数据的 Blob 对象。
//"document" _________ 是一个 HTML Document 或 XML XMLDocument，根据接收到的数据的 MIME 类型而定。请参阅 HTML in XMLHttpRequest 中的 HTML，了解有关使用 XHR 获取 HTML 内容的更多信息。
//"json" _____________  是通过将接收到的数据内容解析为 JSON 而创建的 JavaScript 对象。
//"text" _____________ 是 DOMString 对象中的文本。
//"ms-stream" ________ 是流式下载的一部分；此响应类型仅允许用于下载请求，并且仅受 Internet Explorer 支持。


function WebPost(reqFileHeader, parameterGetMap, parameterPostMap, callback_dataStr) {
    WebPost_postData(reqFileHeader, parameterGetMap, JSON.stringify(parameterPostMap), "json", "text", callback_dataStr);
}

function WebPost_postData(reqFileHeader, parameterGetMap, postData, postDataType, returnType, callback_data) {
    _init_webData();
    let urlData = document.c_data.url + reqFileHeader + "?postDataType=" + postDataType;
    if (parameterGetMap != null) {
        Object.keys(parameterGetMap).forEach(function (key) {
            urlData += "&" + (key + "=" + parameterGetMap[key]).replace(" ", "_");
        });
    }
    var xhr = new XMLHttpRequest();
    xhr.open("POST", urlData, true);
    xhr.responseType = returnType;
    xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
    xhr.onreadystatechange = function () {
        var XMLHttpReq = xhr;
        console.log("WebPost.消息响应__________readyState=" + XMLHttpReq.readyState + "......status=" + XMLHttpReq.status);
        /**
         XMLHttpReq.readyState
         0: 请求未初始化
         1: 服务器连接已建立
         2: 请求已接收
         3: 请求处理中
         4: 请求已完成，且响应已就绪
         **/
        if (XMLHttpReq.readyState == 4) {
            if (XMLHttpReq.status == 200) {
                if (returnType == "" || returnType == "text") {
                    let dataStr = XMLHttpReq.responseText;
                    callback_data(dataStr);
                } else {
                    let data = XMLHttpReq.response;
                    callback_data(data);
                }
                //alert(dataStr);
                //console.log(dataStr); 
                //var json = JSON.parse(dataStr); 
            } else if (XMLHttpReq.status == 100) {

            } else if (XMLHttpReq.status == 300) {

            } else if (XMLHttpReq.status == 400) {

            } else if (XMLHttpReq.status == 500) {

            } else if (XMLHttpReq.status == 0) {
                /** 0不是http协议的状态,关于XMLHttpReq.status的说明:
                 1、If the state is UNSENT or OPENED, return 0.（如果状态是UNSENT或者OPENED，返回0）
                 2、If the error flag is set, return 0.（如果错误标签被设置，返回0）
                 3、Return the HTTP status code.（返回HTTP状态码）
                 第一种情况,例如:url请求的是本地文件,状态会是0
                 第二种情况经常出现在跨域请求中,比如url不是本身网站IP或域名,例如请求www.baidu.com时
                 第三种,正常请求本站http协议信息时,正常返回http协议状态值
                 **/
            }
        }
    };
    xhr.send(postData);
}


function WebGet(reqFileHeader, parameterGetMap, callback_dataStr) {
    _init_webData();
    let urlData = document.c_data.url + reqFileHeader + "?";
    //console.log("发送请求____S_get_____"); 

    Object.keys(parameterGetMap).forEach(function (key) {
        urlData += "&" + (key + "=" + parameterGetMap[key]).replace(" ", "_");
    });

    var xhr = new XMLHttpRequest();
    xhr.open("Get", urlData, true);
    xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
    xhr.onreadystatechange = function () {
        var XMLHttpReq = xhr;
        console.log("WebGet.消息响应__________readyState=" + XMLHttpReq.readyState + "......status=" + XMLHttpReq.status);
        /**
         XMLHttpReq.readyState
         0: 请求未初始化
         1: 服务器连接已建立
         2: 请求已接收
         3: 请求处理中
         4: 请求已完成，且响应已就绪
         **/
        if (XMLHttpReq.readyState == 4) {
            if (XMLHttpReq.status == 200) {
                let dataStr = XMLHttpReq.responseText;
                //alert(dataStr);
                //console.log(dataStr); 
                //var json = JSON.parse(dataStr);
                callback_dataStr(dataStr);
            } else if (XMLHttpReq.status == 100) {

            } else if (XMLHttpReq.status == 300) {

            } else if (XMLHttpReq.status == 400) {

            } else if (XMLHttpReq.status == 500) {

            } else if (XMLHttpReq.status == 0) {
                /** 0不是http协议的状态,关于XMLHttpReq.status的说明:
                 1、If the state is UNSENT or OPENED, return 0.（如果状态是UNSENT或者OPENED，返回0）
                 2、If the error flag is set, return 0.（如果错误标签被设置，返回0）
                 3、Return the HTTP status code.（返回HTTP状态码）
                 第一种情况,例如:url请求的是本地文件,状态会是0
                 第二种情况经常出现在跨域请求中,比如url不是本身网站IP或域名,例如请求www.baidu.com时
                 第三种,正常请求本站http协议信息时,正常返回http协议状态值
                 **/
            }
        }
    }
    xhr.send(null);
}


///文件上传
function WebPost_FileSave(filePath, fileBytes, callback_dataStr) {
    let parameterGetMap = {
        "filePath": filePath,//"/Users/mac/Desktop/test_js/" + fileObj.name, 
    }
    WebPost_postData("/File.WriteAllBytes", parameterGetMap, fileBytes, "blob", "text", callback_dataStr);
}

///根据路径加载文件
function WebPost_FileRead(filePath, returnType, callback_bytes) {
    let parameterPostMap = {
        "filePath": filePath,//"/Users/mac/Desktop/test_js/" + fileObj.name, 
    }
    WebPost_postData("/File.ReadAllBytes", null, JSON.stringify(parameterPostMap), "json", returnType, callback_bytes);
}


///根据路径加载图片---已过时----请使用( WebPost_FileRead() )
function WebPost_LoadImageBytes(filePath, callback_bytes) {
    _init_webData();
    var xmlhttp;
    xmlhttp = new XMLHttpRequest();
    xmlhttp.open("POST", document.c_data.url + "/File.ReadAllBytes?", true);
    xmlhttp.responseType = "blob";
    xmlhttp.onload = function () {
        console.log(this);
        if (this.readyState == 4 && this.status == 200) {
            var blob = this.response;
            //console.log(blob);
            callback_bytes(blob)
            if (false) {
                var img = document.createElement("img");
                img.onload = function (e) {
                    window.URL.revokeObjectURL(img.src);
                };
                img.src = window.URL.createObjectURL(blob);
                img.style.width = "500px";
                img.style.height = "300px";
                document.body.appendChild(img);
            }
        }
    }
    let parameterPostMap = {
        "filePath": filePath,
    }
    xmlhttp.send(JSON.stringify(parameterPostMap));
}


///文件上传
function WebPost_UploadFile(fileObj, progressEvent, callBack) {
    _init_webData();
    // 文件切块大小为1MB
    const chunkSize = 1024 * 1024 * 2;
    //let fileObj = document.getElementById('file').files[0];
    // 初始化上传大小
    function init() {
        let xhr = new XMLHttpRequest();
        xhr.onload = function () {
            console.log("init.onload......readyState=" + this.readyState + "......status=" + this.status);
        }
        xhr.error = function (e) {
            console.log("init.error..请求错误..." + e);
        };
        xhr.onreadystatechange = function () {
            console.log("init.onreadystatechange......readyState=" + this.readyState + "......status=" + this.status);
            if (this.readyState == 4 && this.status == 200) {
                // 将字符串转化为整数
                let start = parseInt(this.responseText);
                // 设置进度条
                // let progress = document.getElementById('progress');
                // progress.max = fileObj.size;
                // progress.value = start;
                if (progressEvent != null) {
                    progressEvent(start, fileObj.size)
                }
                console.log("init()...开始上传_______start=" + start);
                // 开始上传
                upload(start);
            }
        }
        xhr.open('post', document.c_data.url + "/FileUpload?postDataType=json", true);
        xhr.responseType = "text";
        let postData = {
            "filePath": "/Users/mac/Desktop/test_js/" + fileObj.name,
            "fileStartPos": 0,
            "fileEndPos": 0,
            "fileLength": fileObj.size,
            "uploadType": 1,
        }
        // 向服务器发送文件名查询大小
        xhr.send(JSON.stringify(postData));
    }

    // 从start字节处开始上传
    function upload(start) {
        //let fileObj = document.getElementById('file').files[0];
        // 上传完成
        if (start >= fileObj.size) {
            if (callBack != null) {
                callBack();
            }
            return;
        }
        // 获取文件块的终止字节
        let end = (start + chunkSize > fileObj.size) ? fileObj.size : (start + chunkSize);
        // 将文件切块上传
        // let fd = new FormData();
        // fd.append('file', fileObj.slice(start, end));
        let fd = fileObj.slice(start, end);
        // POST表单数据
        let xhr = new XMLHttpRequest();
        xhr.onload = function () {
            console.log("xhr.onload..开始继续上传______..readyState=" + this.readyState + "......status=" + this.status);
            if (this.readyState == 4 && this.status == 200) {
                // 上传一块完成后修改进度条信息，然后上传下一块
                // let progress = document.getElementById('progress');
                // progress.max = fileObj.size;
                // progress.value = end; 
                let end0 = parseInt(this.responseText);
                if (progressEvent != null) {
                    progressEvent(end, fileObj.size)
                }
                console.log("xhr.onload..开始继续上传______..end0=" + end0 + "......end=" + end);
                upload(end);
            }
        }
        xhr.error = function (e) {
            console.log("xhr.error..请求错误..." + e);
        };
        xhr.onreadystatechange = function () {
            console.log("xhr.onreadystatechange...........readyState=" + this.readyState + "......status=" + this.status);
            if (this.readyState == 3 && this.status == 200) {
            }
        };
        console.log("xhr.send.....readyState=" + xhr.readyState + "...status=" + xhr.status + "...." + fileObj.name + ".......(" + start + "__" + end + ")/" + fileObj.size + ".." + (end - start));

        let parameterGetMap = {
            "filePath": "/Users/mac/Desktop/test_js/" + fileObj.name,
            "fileStartPos": start,
            "fileEndPos": end,
            "fileLength": fileObj.size,
            "uploadType": 2,
        }
        let urlData = document.c_data.url + "/FileUpload?postDataType=blob";
        Object.keys(parameterGetMap).forEach(function (key) {
            urlData += "&" + (key + "=" + parameterGetMap[key]).replace(" ", "_");
        });
        xhr.open('post', urlData, true);
        xhr.responseType = "text";
        xhr.send(fd);
    }

    init();
}


///获取目录下的文件路径
function WebPost_getDirFiles(dir, midDir, ignoreDir, suffixArr, isTop, isGetFileSystemType, callback_dfStr) {
    _init_webData();
    let parameterGetMap = {
        "dir": dir,// "/Library/WebServer/test",
        "midDir": midDir,// "Resourecs/txtData|/Art01/",
        "ignoreDir": ignoreDir,// "/.|.git",
        "suffixArr": suffixArr,// ".png|.jpeg|.jpg",
        "isTop": isTop,// 1,
        "isGetFileSystemType": isGetFileSystemType,// 1,
    }
    WebPost("/Directory.GetFiles", parameterGetMap, null, function (dfStr) {
        callback_dfStr(dfStr)
        if (false) {
            //let jsonPathArr = JSON.parse(jsonStr);
            let pathList = CFile_dfStrToFileList(dfStr);
        }
    })
}