o_dragData = {}
o_dragData.name = "o_dragData";

//设置物体组件的拖动事件----
function CardDrag_SetDrag(card) {
    let thisObj = o_dragData;
    thisObj._typeName = "CardDrag";
    thisObj.selectCard = null;
    thisObj.isDown = false;
    //鼠标按下事件
    card.onmousedown = function (e) {
        let now = Date.now();
        if (o_dragData.frameCount == now) {
            return
        }
        o_dragData.frameCount = now;

        card = this;
        //获取x坐标和y坐标
        thisObj.press_clientX = e.clientX;
        thisObj.press_clientY = e.clientY;

        //获取左部和顶部的偏移量
        thisObj.press_posX = card.offsetLeft;
        thisObj.press_posY = card.offsetTop;
        //开关打开
        thisObj.isDown = true;

        //设置样式
        card.style.cursor = 'move';
        card.style.zIndex_last = card.style.zIndex;
        card.style.zIndex = 100;
        thisObj.selectCard = card;
        if (card.d_dragEvent != null) {
            card.d_dragEvent(thisObj.selectCard.o_thisObj, 1, thisObj.press_posX, thisObj.press_posY);
        }
    }
    //鼠标移动
    window.onmousemove = function (e) {
        if (thisObj.isDown == false) {
            return;
        }
        //计算移动后的左偏移量和顶部的偏移量
        thisObj.offectX = e.clientX - thisObj.press_clientX;
        thisObj.offectY = e.clientY - thisObj.press_clientY;
        let posX = thisObj.press_posX + thisObj.offectX;
        let posY = thisObj.press_posY + thisObj.offectY;

        if (thisObj.selectCard.o_posXIsFixed == null) {
            let posXmin = thisObj.selectCard.o_posXmin;
            let posXMax = thisObj.selectCard.o_posXMax
            if (posXmin != null) {
                if (posX < posXmin) {
                    posX = posXmin;
                }
            }
            if (posXMax != null) {
                if (posX > posXMax) {
                    posX = posXMax;
                }
            }
            thisObj.selectCard.style.left = posX + 'px';
        }

        if (thisObj.selectCard.o_posYIsFixed == null) {
            let posYmin = thisObj.selectCard.o_posYmin;
            let posYMax = thisObj.selectCard.o_posYMax
            if (posYmin != null) {
                if (posY < posYmin) {
                    posY = posYmin;
                }
            }
            if (posYMax != null) {
                if (posY > posYMax) {
                    posY = posYMax;
                }
            }
            thisObj.selectCard.style.top = posY + 'px';
        }

        //console.log("dddddddddddddddddddddddddd");
        if (thisObj.selectCard.d_dragEvent != null) {
            if (thisObj.selectCard == null) {
                cc.log("dddddd")
            }
            thisObj.selectCard.d_dragEvent(thisObj.selectCard.o_thisObj, 2, thisObj.offectX, thisObj.offectY);
        }
    }
    //鼠标抬起事件
    window.onmouseup = function () {
        if (thisObj.isDown == false) {
            return;
        }
        //开关关闭
        thisObj.isDown = false;
        card = thisObj.selectCard;
        card.style.cursor = 'default';
        card.style.zIndex = card.style.zIndex_last;
        if (card.d_dragEvent != null) {
            if (card == null) {
                cc.log("拖动结束事件错误......card==null")
            }
            card.d_dragEvent(card.o_thisObj, 3, thisObj.offectX, thisObj.offectY);
        }
    }
    //card.mmm = 5;
}

//屏蔽拖动
function CardDrag_shieldDrag(card) {
    card.onmousedown = function (e) { 
        o_dragData.frameCount = Date.now();
    } 
}