/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class FirstInterface
extends JFrame {
    private static final long serialVersionUID = 1L;
    public static final String RESULT_IMAGE_FILE_NAME = "atlas_texture.png";
    public static final String ATLAS_STRUCTURE_FILE_NAME = "atlas_structure.txt";
    JTextField sizeField;
    JTextField widthLimitField;
    int frameWidth = 400;
    int frameHeight = 300;
    Font font;
    ArrayList<Block> blocks = new ArrayList();
    JTextArea outputArea;

    private FirstInterface() {
        super("Atlas texture creator by yiotro");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ignored) {
            // empty catch block
        }
        MyButtonListener myButtonListener = new MyButtonListener(this);
        this.font = new Font("Segoe UI", 0, 14);
        this.setFont(this.font);
        this.setLayout(null);
        this.outputArea = new JTextArea("Program successfully started\n");
        this.outputArea.setFont(new Font("Courier New", 0, 12));
        JScrollPane scrollPane2 = new JScrollPane(this.outputArea);
        scrollPane2.setBounds(5, 5, this.frameWidth - 20, this.frameHeight - 75);
        this.add(scrollPane2);
        this.sizeField = new JTextField("3");
        this.sizeField.setFont(this.font);
        this.sizeField.setBounds(5, this.frameHeight - 65, 30, 30);
        this.add(this.sizeField);
        this.widthLimitField = new JTextField("1000");
        this.widthLimitField.setFont(this.font);
        this.widthLimitField.setBounds(40, this.frameHeight - 65, 50, 30);
        this.add(this.widthLimitField);
        JButton generateButton = new JButton("\u0421\u043e\u0437\u0434\u0430\u0442\u044c atlas");
        generateButton.setActionCommand("create atlas texture");
        generateButton.setBounds(this.frameWidth - 135, this.frameHeight - 65, 120, 30);
        generateButton.addActionListener(myButtonListener);
        generateButton.setFont(this.font);
        this.add(generateButton);
        JButton makeLowButton = new JButton("Low");
        makeLowButton.setActionCommand("low");
        makeLowButton.setBounds(this.frameWidth - 200, this.frameHeight - 65, 60, 30);
        makeLowButton.addActionListener(myButtonListener);
        makeLowButton.setFont(this.font);
        this.add(makeLowButton);
        this.setSize(this.frameWidth, this.frameHeight);
        this.setVisible(true);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (int)((dimension.getWidth() - (double)this.getWidth()) / 2.0);
        int y = (int)((dimension.getHeight() - (double)this.getHeight()) / 2.0);
        this.setLocation(x, y);
        this.loadEverything();
    }

    void loadEverything() {
        this.loadBlocks();
        this.loadCompressionRate();
        this.loadRowsNumber();
        this.say("ready");
    }

    private void loadBlocks() {
        File folder = new File(System.getProperty("user.dir"));
        this.blocks.clear();
        for (File fileEntry : folder.listFiles()) {
            if (!this.isValidPngFile(fileEntry)) continue;
            Block block = new Block(fileEntry);
            this.blocks.add(block);
        }
        Collections.sort(this.blocks);
        this.say("images loaded: " + this.blocks.size());
    }

    public void updateBlockPositions() {
        int currentX = 0;
        int maxRowHeight = 0;
        int currentY = 0;
        int currentColumnWidth = 0;
        int widthLimit = this.getWidthLimit();
        for (Block block : this.blocks) {
            BufferedImage image = block.image;
            if (currentColumnWidth + image.getWidth() >= widthLimit) {
                currentY += maxRowHeight + 1;
                maxRowHeight = 0;
                currentColumnWidth = 0;
                currentX = 0;
            }
            block.position.x = currentX;
            block.position.y = currentY;
            currentX += image.getWidth() + 1;
            currentColumnWidth += image.getWidth() + 1;
            if (image.getHeight() <= maxRowHeight) continue;
            maxRowHeight = image.getHeight();
        }
        this.say("positions updated");
    }

    int getResultHeight() {
        int max = 0;
        for (Block block : this.blocks) {
            int current = (int)(block.position.y + block.position.height);
            if (current <= max) continue;
            max = current;
        }
        return max;
    }

    public int getWidthLimit() {
        return Integer.valueOf(this.widthLimitField.getText());
    }

    boolean isValidPngFile(File file) {
        return file.getName().contains(".png") && !file.getName().equals(RESULT_IMAGE_FILE_NAME);
    }

    boolean isLowImage(Block block) {
        return block.fileName.contains("_low.png");
    }

    boolean isLowestImage(Block block) {
        return block.fileName.contains("_lowest.png");
    }

    boolean isNormalImage(Block block) {
        return !this.isLowestImage(block) && !this.isLowImage(block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadRowsNumber() {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(ATLAS_STRUCTURE_FILE_NAME));
            String line = br.readLine();
            while (line != null) {
                if (!line.contains("rows=")) {
                    line = br.readLine();
                    continue;
                }
                int charPos = line.indexOf("=");
                String compRate = line.substring(charPos + 1, line.length());
                this.widthLimitField.setText(compRate);
                break;
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.say("width = " + this.widthLimitField.getText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadCompressionRate() {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(ATLAS_STRUCTURE_FILE_NAME));
            String line = br.readLine();
            while (line != null) {
                if (!line.contains("compression=")) {
                    line = br.readLine();
                    continue;
                }
                int charPos = line.indexOf("=");
                String compRate = line.substring(charPos + 1, line.length());
                this.sizeField.setText(compRate);
                break;
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.say("compression rate = " + this.sizeField.getText());
    }

    public void say(String message) {
        System.out.println(message);
        if (this.outputArea != null) {
            String text = this.outputArea.getText();
            String newText = text + message + "\n";
            this.outputArea.setText(newText);
            this.outputArea.update(this.outputArea.getGraphics());
        }
    }

    public static void main(String[] args) {
        FirstInterface f = new FirstInterface();
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                System.exit(0);
            }
        });
    }
}

