/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.Timer;

class MyButtonListener
implements ActionListener {
    private final FirstInterface firstInterface;
    private Timer timer;

    MyButtonListener(FirstInterface firstInterface) {
        this.firstInterface = firstInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveTextFile() {
        BufferedWriter writer = null;
        try {
            File txtFile = new File("atlas_structure.txt");
            writer = new BufferedWriter(new FileWriter(txtFile));
            writer.write("compression=" + Double.valueOf(this.firstInterface.sizeField.getText()));
            writer.newLine();
            writer.write("rows=" + Integer.valueOf(this.firstInterface.widthLimitField.getText()));
            writer.newLine();
            for (Block block : this.firstInterface.blocks) {
                String str = block.fileName;
                RectangleYio pos = block.position;
                writer.write(str + "#" + (int)pos.x + " " + (int)pos.y + " " + (int)pos.width + " " + (int)pos.height);
                writer.newLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    void saveImageFile() {
        int resultWidth = this.firstInterface.getWidthLimit();
        int resultHeight = this.firstInterface.getResultHeight();
        BufferedImage resultImage = new BufferedImage(resultWidth, resultHeight, 2);
        Graphics2D graphics2D = (Graphics2D)resultImage.getGraphics();
        for (Block block : this.firstInterface.blocks) {
            graphics2D.drawImage((Image)block.image, (int)block.position.x, (int)block.position.y, null);
        }
        try {
            ImageIO.write((RenderedImage)resultImage, "png", new File("atlas_texture.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.firstInterface.say("atlas saved");
    }

    String getLowFileName(String srcName) {
        StringBuilder builder = new StringBuilder();
        int index = srcName.indexOf(".");
        String name = srcName.substring(0, index);
        String ext = srcName.substring(index + 1, srcName.length());
        builder.append(name);
        builder.append("_low.");
        builder.append(ext);
        return builder.toString();
    }

    String getLowestFileName(String srcName) {
        StringBuilder builder = new StringBuilder();
        int index = srcName.indexOf(".");
        String name = srcName.substring(0, index);
        String ext = srcName.substring(index + 1, srcName.length());
        builder.append(name);
        builder.append("_lowest.");
        builder.append(ext);
        return builder.toString();
    }

    void createLowImageFiles() {
        for (Block block : this.firstInterface.blocks) {
            if (!this.firstInterface.isNormalImage(block)) continue;
            BufferedImage image = block.image;
            double compressionRate = Double.valueOf(this.firstInterface.sizeField.getText());
            int imageWidth = this.getNewImageWidth(image, compressionRate);
            int imageHeight = this.getNewImageHeight(image, compressionRate);
            String fileName = this.getLowFileName(block.fileName);
            this.makeCompressedImage(image, imageWidth, imageHeight, fileName);
        }
        this.firstInterface.loadEverything();
    }

    private void makeCompressedImage(BufferedImage image, int imageWidth, int imageHeight, String fileName) {
        BufferedImage resultImage = new BufferedImage(imageWidth, imageHeight, 2);
        Graphics2D graphics2D = (Graphics2D)resultImage.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.drawImage(image, 0, 0, imageWidth, imageHeight, null);
        try {
            ImageIO.write((RenderedImage)resultImage, "png", new File(fileName));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private int getNewImageHeight(BufferedImage image, double compressionRate) {
        int imageHeight = (int)((double)image.getHeight() / compressionRate);
        if (imageHeight < 1) {
            imageHeight = 1;
        }
        return imageHeight;
    }

    private int getNewImageWidth(BufferedImage image, double compressionRate) {
        int imageWidth = (int)((double)image.getWidth() / compressionRate);
        if (imageWidth < 1) {
            imageWidth = 1;
        }
        return imageWidth;
    }

    void createLowestImageFiles() {
        for (Block block : this.firstInterface.blocks) {
            if (!this.firstInterface.isNormalImage(block)) continue;
            BufferedImage image = block.image;
            double compressionRate = Double.valueOf(this.firstInterface.sizeField.getText());
            int imageWidth = this.getNewImageWidth(image, compressionRate *= 2.0);
            int imageHeight = this.getNewImageHeight(image, compressionRate);
            String fileName = this.getLowestFileName(block.fileName);
            this.makeCompressedImage(image, imageWidth, imageHeight, fileName);
        }
        this.firstInterface.loadEverything();
    }

    private void applyTimer() {
        this.timer = new Timer(2000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyButtonListener.this.firstInterface.say("time passed");
                MyButtonListener.this.timer.stop();
            }
        });
        this.timer.start();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("create atlas texture")) {
            this.firstInterface.updateBlockPositions();
            this.saveImageFile();
            this.saveTextFile();
            this.firstInterface.say("all done");
        } else if (e.getActionCommand().equals("low")) {
            this.createLowImageFiles();
            this.createLowestImageFiles();
            this.firstInterface.say("low images created");
            this.applyTimer();
        }
    }
}

