(function() {
    var callbackQueue = new Object();
    var uniqueId = 1;

    function _callNative(methodName, parameters, responseCallback) {
        if (responseCallback == undefined) {
            responseCallback = function() {};
        }
        var callbackId = 'cb_' + (uniqueId++) + '_' + new Date().getTime();
        callbackQueue[callbackId] = responseCallback;
        EYOAPI.call(JSON.stringify({
            callbackId: callbackId,
            methodName: methodName,
            parameters: parameters
        }));

    }

    function _nativeCallJs(message) {
        var call = callbackQueue[message.callbackId];
        var arr = [];
        for (var i in message.data) {
            arr.push(message.data[i]);
        }
        call(arr[0], arr[1], arr[2], arr[3], arr[4], arr[5], arr[6], arr[7]);
        delete callbackQueue[message.callbackId];
        return "ok";
    }
    function getContent(responseCallback) {
        _callNative("getContent", {},
        responseCallback);
    }
    function getVipWarfare(responseCallback) {
        _callNative("getVipWarfare", {},
        responseCallback);
    }
    function receiveVipWarfare(vipLevel, responseCallback) {
        _callNative("receiveVipWarfare", {
            vipLevel: vipLevel
        },
        responseCallback);
    }
    function buyGoods(title,name, iconUrl,type,originalPrice,price,vipGoodsId, responseCallback) {
        _callNative("buyGoods", {
            title: title,
            name: name,
            iconUrl:iconUrl,
            type:type,
            originalPrice:originalPrice,
            price:price,
            vipGoodsId:vipGoodsId
        },
        responseCallback);
    }
    window._nativeCallJs = _nativeCallJs;
    window.EyoSdk = {
        getContent: getContent,
        getVipWarfare: getVipWarfare,
        receiveVipWarfare: receiveVipWarfare,
        buyGoods: buyGoods,
    };
})();