(function() {
	var callbackQueue = new Object();
	var uniqueId = 1;

	function _callNative(methodName, parameters, responseCallback) {
		if (responseCallback==undefined) {
		    responseCallback = function(){};
		}
		var callbackId = 'cb_' + (uniqueId++) + '_' + new Date().getTime();
		callbackQueue[callbackId] = responseCallback;
		EYOAPI.call(JSON.stringify({
			callbackId: callbackId,
			methodName: methodName,
			parameters: parameters
		}));

	}

	function _nativeCallJs(message) {
		var call = callbackQueue[message.callbackId];
		var arr = [];
		for (var i in message.data) {
			arr.push(message.data[i]);
		}
		call(arr[0], arr[1], arr[2], arr[3], arr[4], arr[5], arr[6], arr[7]);
		delete callbackQueue[message.callbackId];
		return "ok";
	}
	//horizontal vertical
	function init(appKey, orientation, responseCallback) {
		_callNative("init", {
				appKey: appKey,
				orientation: orientation
			},
			responseCallback);
	}

	function login(responseCallback) {
		_callNative("login", {},
			responseCallback);
	}

	function pay(gameOrderId, price, itemCode, itemName, responseCallback) {
		_callNative("pay", {
				gameOrderId: gameOrderId,
				price: price,
				itemCode: itemCode,
				itemName: itemName,
			},
			responseCallback);
	}


	function setRoleData(roleId, roleName, roleLevel, vipLevel, zoneId, zoneName, responseCallback) {
		_callNative("setRoleData", {
				roleId: roleId,
				roleName: roleName,
				roleLevel: roleLevel,
				vipLevel: vipLevel,
				zoneId: zoneId,
				zoneName: zoneName,
			},
			function() {});
	}
	window._nativeCallJs = _nativeCallJs;

	window.EYOSDK = {
		init: init,
		login: login,
		pay: pay,
		setRoleData: setRoleData
	};
})();