window.zlapi = {
    randomString:function(len) {
    　　len = len || 32;
    　　var $chars = 'ABCDEFGHJKMNPQRSTWXYZabcdefhijkmnprstwxyz2345678';
    　　var maxPos = $chars.length - 1;
    　　var pwd = '';
    　　for (i = 0; i < len; i++) {
    　　　　pwd += $chars.charAt(Math.floor(Math.random() * maxPos));
    　　}
    　　return pwd;
    },
    isiPhone: function() {
        try {
            var userAgentInfo = navigator.userAgent;
            return userAgentInfo.match(/(iPhone|iPod|iPad|ios)/i);
        } catch(e) {
            return false;
        }
    },
    addMethodListener:function(method) {
        var wzlapp = window.zlapp || window.webkit.messageHandlers;

        var _this = this;
        _this[method] = function(params) {
            var callbackKey = _this.randomString(32)+_this.randomString(32)+'_'+method+'_'+(Date.parse(new Date()));
            params = Object.prototype.toString.call(params) == '[object Object]' ?params : {};
            params.data = params.data || {};
            params.data.callbackKey = callbackKey;

            params.success = typeof(params.success) == 'function' ?params.success: function() {};
            params.fail = typeof(params.fail) == 'function' ?params.fail: function() {};

            var  jsonString = JSON.stringify(params.data);
            if (_this.callbackMap[callbackKey]) {
                params.fail('回调函数冲突，请重试');
                return;
            }
            _this.callbackMap[callbackKey] = params;
            if (!wzlapp[method]) {
                params.fail('方法不存在:'.method);
                return;
            }
            try {
                var isiPhone = _this.isiPhone();
                if (isiPhone) {
                    if (typeof(wzlapp[method].postMessage) == 'function') {
                        wzlapp[method].postMessage(jsonString);
                    } else {
                        wzlapp[method](jsonString);
                    }
                } else {//android调用方法
                    if (typeof(wzlapp[method]) == 'function') {
                        wzlapp[method](jsonString);
                    } else {
                        wzlapp[method].postMessage(jsonString);
                    }
                }
            } catch(e) {
                params.fail(e.stack);
            }
        };
    },
    init:function() {
        try{
            var _this = this;
            _this.addMethodListener('getMethods');

            _this.getMethods({
                success:function(methods) {
                    if (!Array.isArray(methods)) {
                        return;
                    }
                    for (var i =0;i <methods.length;i++ ) {
                        _this.addMethodListener(methods[i]);
                    }
                    Object.freeze(window.zlapi);
                    Object.defineProperty(window, 'zlapi', {
                        configurable: false,
                        writable: false
                    });
                    typeof window.apiready == 'function' && window.apiready(methods);
                }
            });
        }catch(e){
            console.log(e);
        }
    },
    callback:function(callbackKey,json) {
        if (!callbackKey || !this.callbackMap[callbackKey]) {
            return;
        }
        var params = this.callbackMap[callbackKey];
        try {
            var retValue = Object.prototype.toString.call(json) == '[object Object]' ? json:JSON.parse(json);
            if (retValue.ret === 0) {
                params.success(retValue.data);
            } else {
                params.fail(retValue.errmsg);
            }
        }catch(e) {
            params.fail(e.stack);
            console.log(e);
        }
    },
    callbackMap:{},//函数映射对象
    //app触发某些特定事件后的回调，如切换前台后台事件
    callEventListener:function(event,data) {
      var eventList = this.eventCallbackMap[event];

      if (!eventList || !Array.isArray(eventList)) return;

      eventList.forEach(function(func) {
         typeof func == 'function' && func(data);
      })
    },
    //添加一个app监听
    addEventListener:function(event,func) {
    var eventList = this.eventCallbackMap[event];

    if(!eventList || !Array.isArray(eventList)) {
        this.eventCallbackMap[event] = eventList = [];
    }

    eventList.push(func)
    },
    //存放所有的事件监听
    eventCallbackMap:{}
}
