<!Doctype html>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ page contentType="text/html;charset=UTF-8" %>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
<style type="text/css">
	body {
		margin: 0;
		padding: 0;
		font-size: 16px;
		font-family:'微软雅黑',Sans-Serif;
		background: #EEE;
	}
	.main_container {
		text-align: center;
	}
	.popup_container {
		width: 650px;
		/*width: auto;*/
		margin: 20px auto;
		background-color: #ffffff;
		padding: 10px;
	}
	.notice_title {
		overflow: auto;
		clear: both;
		margin-top: 20px;
	}
	.notice_title div{
		float: left;
		width: 33.3%;
	}

	.right_part .line_1{margin-left: 50px;}
	div span.underline {
		/*text-decoration: underline;	*/
		display: inline-block;
		border-bottom: 1px solid #000000;
		width: 100px;
	}
	.notice_container {
		margin-top: 20px;
		overflow: auto;
		clear: both;
		border:1px solid #000000;
	}
	.notice_container div.left_part {
		float: left;
		width: 10%;
		padding: 10px;
		text-align: left;
	}
	.notice_container div.right_part {
		float: left;
		width: 83%;
		border-left: 1px solid #000000;
		padding: 10px 10px 20px;
		text-align: left;
		font-size: 14px;
	}
	.notice_container div.left_part div.disease_space {
		margin-top: 5px;
	}
	.notice_container div.right_part div.notice_info {
		margin-top: 30px;
	}
	.jiliang .underline,.hospital .underline{width: 440px;}
	.number .underline,.doctor_register .underline{width: 412px;}
	.doctor_responsable .underline{width: 342px;}
	@media only screen and (min-width: 320px) and (max-width: 480px){
		.popup_container {
			width: 93%;
			margin: 0 auto;
		}
		.notice_container div.left_part{width: 6%;}
		.notice_container div.right_part{width: 80%;}
		div span.underline{width: 14.5%;}
		.right_part .line_1{margin-left: 10px;}
		.jiliang .underline,.hospital .underline{width: 68.6%;}
		.number .underline,.doctor_register .underline{width: 56.8%;}
		.doctor_responsable .underline{width: 44.2%;}
		.time span.underline{width: 14%;}
	}
	
	@media only screen and (min-device-width: 375px) and (max-device-width: 667px){
		div span.underline{width: 27%;}
		.jiliang .underline,.hospital .underline{width: 73.2%;}
		.number .underline,.doctor_register .underline{width: 63.1%;}
		.doctor_responsable .underline{width: 52.9%;}
		.time span.underline{width: 16.8%;}
	}

	@media only screen and (min-device-width: 414px) and (max-device-width: 736px){
		div span.underline{width: 33.9%;}
		.jiliang .underline,.hospital .underline{width: 75.8%;}
		.number .underline,.doctor_register .underline{width: 66.6%;}
		.doctor_responsable .underline{width: 43.8%;}
		.time span.underline{width: 18.4%;}
	}
</style>

<title>处方笺</title>
</head>
<body>
	<div class="main_container">
		<span style="color:#ff0000">  <c:if test="${desc != null}"><c:out value="提示：${desc}"/></c:if></span>
		<c:forEach items="${data}" var="item">
		<div class="popup_container">
			<div style="text-align: left; height: 32px;line-height: 32px;border-bottom: 1px solid #ccc;margin-bottom: 10px;">
				<span style="text-align: left;">第一次领药处方笺</span>
			</div>
			<div>
				<img style=" vertical-align:middle;" src="http://efangapk.ufile.ucloud.com.cn/recipe_logo.png">
				<span>中华慈善总会格列卫患者援助项目线上专用处方笺</span>
			</div>
			<div class="notice_title">
				<div>
					<span>患者姓名：</span>
					<span class="underline" style="width: 84px;"><center>XXX</center></span>
				</div>
				<div>
					<span>性别：</span>
					<span class="underline" style="width: 80px;"><center>X</center></span>
				</div>
				<div>
					<span>年龄：</span>
					<span class="underline" style="width: 80px;"><center>XX</center></span>
				</div>
			</div>

			<div class="notice_container">
				<div class="left_part">
					<div>
						<span>适应症</span>
					</div>
					<div style="margin-top:30px">
						<div><center>隆凸纤维肉瘤</center></div>
					</div>
				</div>
				<div class="right_part">
					<div class="line_1">
						<span>R:</span>
					</div>
					<div style="text-align:center;margin-top:10px;">
						<span><center>格列卫（甲磺酸伊马替尼片）</center></span>
					</div>
					<div class="notice_info jiliang">
						<span>推荐剂量：</span>
						<span class="underline"><center>600mg/天</center></span>
					</div>
					<div class="notice_info number">
						<span>
							建议服药盒数：
						</span>
						<span class="underline"><center>3.0盒</center></span>
					</div>
					<div class="notice_info hospital">
						<span>
							医院名称：
						</span>
						<span class="underline"><center>北京朝阳医院</center></span>
					</div>
					<div class="notice_info doctor_register">
						<span>
							注册医生姓名：
						</span>
						<span class="underline"><center>王红兰</center></span>
					</div>
					<div class="notice_info doctor_responsable">
						<span>
							项目注册医生签章：<!--<span style="color:#ff0000"></span>：-->
						</span>
						<span class="underline"><center>王红兰</center></span>
					</div>
					<div class="notice_info doctor_register">
						<span>
							处方日期：
						</span>
						<span class="underline time"><center>2016年6月20日</center></span>
					</div>
				</div>
			</div>
		</div>
		</c:forEach>
		<div align="center">
			<span style="color:#ff0000"> <c:if test="${kindlyReminder != null}"><c:out value="温馨提示：${kindlyReminder}"/></c:if></span>
		</div>
	</div>
</body>
</html>