;(function() {
    if (window.WebViewJavascriptBridge) { return }
    var messagingIframe
    var receiveMessageQueue = []
    var messageHandlers = {}
    
    var JSInterface = window.__wvjb__;
    
    var responseCallbacks = {}
    var uniqueId = 1

    function init(messageHandler) {
        if (WebViewJavascriptBridge._messageHandler) { throw new Error('WebViewJavascriptBridge.init called twice') }
        WebViewJavascriptBridge._messageHandler = messageHandler
        var receivedMessages = receiveMessageQueue
        receiveMessageQueue = null
        for (var i=0; i<receivedMessages.length; i++) {
            _dispatchMessageFromObjC(receivedMessages[i])
        }
    }

    function send(data, responseCallback) {
        _doSend({ data:data }, responseCallback)
    }
    
    function registerHandler(handlerName, handler) {
        messageHandlers[handlerName] = handler
    }
    
    function callHandler(handlerName, data, responseCallback) {
        var callbackId = 'cb_'+(uniqueId++)+'_'+new Date().getTime()
        responseCallbacks[callbackId] = responseCallback
        JSInterface.callHandler(handlerName, data, callbackId)
    }
    
    function _doSend(message, responseCallback) {
        // TODO: send message to native
    }

    function _responseCallback(callbackid, data) {
        JSInterface.responseCallback(callbackid, data);
    }

    function _dispatchMessageFromAndroid(messageJSON) {
        setTimeout(function _timeoutDispatchMessageFromAndroid() {
            var message = messageJSON
            var messageHandler
            var responseCallback

            if (message.responseId) {
                responseCallback = responseCallbacks[message.responseId]
                if (!responseCallback) { return; }
                responseCallback(message.responseData)
                delete responseCallbacks[message.responseId]
            } else {
                if (message.callbackId) {
                    var callbackResponseId = message.callbackId
                    responseCallback = function(responseData) {
                        _responseCallback(callbackResponseId, responseData)
                    }
                }
                
                var handler = WebViewJavascriptBridge._messageHandler
                if (message.handlerName) {
                    handler = messageHandlers[message.handlerName]
                }
                
                try {
                    handler(message.data, responseCallback)
                } catch(exception) {
                    if (typeof console != 'undefined') {
                        console.log("WebViewJavascriptBridge: WARNING: javascript handler threw.", message, exception)
                    }
                }
            }
        })
    }
    
    function _handleMessageFromAndroid(messageJSON) {
        if (receiveMessageQueue) {
            receiveMessageQueue.push(messageJSON)
        } else {
            _dispatchMessageFromAndroid(messageJSON)
        }
    }

    window.__wvjb__ = window.WebViewJavascriptBridge = {
        init: init,
        send: send,
        registerHandler: registerHandler,
        callHandler: callHandler,
        _handleMessageFromAndroid: _handleMessageFromAndroid
    }

    var doc = document
    var readyEvent = doc.createEvent('Events')
    readyEvent.initEvent('WebViewJavascriptBridgeReady')
    readyEvent.bridge = WebViewJavascriptBridge
    doc.dispatchEvent(readyEvent)
    JSInterface.jsbridgeInitOK()
})();
