var url = location.search.substring(1);

PDFJS.cMapUrl = 'https://unpkg.com/pdfjs-dist@1.9.426/cmaps/';
PDFJS.cMapPacked = true;

var pdfDoc = null;
var pageNum = 1;

function createPage() {
  var div = document.createElement("canvas");
  document.body.appendChild(div);
  return div;
}

function renderPage(num) {
  pdfDoc.getPage(num).then(function (page) {

    var viewport = page.getViewport(2.0);
    var canvas = createPage();
    var ctx = canvas.getContext('2d');

    canvas.height = viewport.height;
    canvas.width = viewport.width;

    page.render({
      canvasContext: ctx,
      viewport: viewport
    });
  });
}

window.onscroll = function() {
    setTimeout(function(){
        document.getElementById("page-wrap").style.display="block";
        var totalHeight = document.body.scrollHeight;
        var top = document.documentElement.scrollTop || document.body.scrollTop;
        var perHeight = totalHeight / pdfDoc.numPages;
        var minPageNum = 1.0 * top / perHeight + 1;
        var maxPageNum = 1.0 * top / perHeight;
        var finalNum = (minPageNum + maxPageNum) / 2;
        pageNum = Math.ceil(finalNum)

        document.getElementById("page-num").innerHTML = pageNum;
        judgeShowOrHide();
    }, 10);
}

function judgeShowOrHide() {
    if (document.getElementById("page-wrap").style.display=="block") {
        setTimeout(function () {
        document.getElementById("page-wrap").style.display="none";
        }, 3000);
    }
}

PDFJS.getDocument(url).then(function (pdf) {
  pdfDoc = pdf;
//    document.getElementById("page-wrap").style.display="block";
    document.getElementById("page-num").innerHTML = pageNum;
    document.getElementById("page-count").innerHTML = "/ " + pdfDoc.numPages;

  for (var i = 1; i <= pdfDoc.numPages; i++) {
    renderPage(i)
  }
});